/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.network.EmptyRightClickToServer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="l2complements", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemUseEventHandler {
    public static final List<ItemClickHandler> LIST = new ArrayList<ItemClickHandler>();

    public static <T extends PlayerEvent> void execute(ItemStack stack, T event, TriCon<T> cons) {
        if (stack.m_41720_() instanceof ItemClickHandler && ((ItemClickHandler)stack.m_41720_()).predicate(stack, event.getClass(), event)) {
            cons.accept((ItemClickHandler)stack.m_41720_(), stack, event);
        }
        for (ItemClickHandler handler : LIST) {
            if (!handler.predicate(stack, event.getClass(), event)) continue;
            cons.accept(handler, stack, event);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            new EmptyRightClickToServer(false, event.getHand() == InteractionHand.MAIN_HAND).toServer();
        }
        ItemUseEventHandler.execute(event.getItemStack(), event, ItemClickHandler::onPlayerLeftClickEmpty);
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemUseEventHandler.execute(event.getItemStack(), event, ItemClickHandler::onPlayerLeftClickBlock);
    }

    @SubscribeEvent
    public static void onPlayerLeftClickEntity(AttackEntityEvent event) {
        ItemUseEventHandler.execute(event.getEntity().m_21205_(), event, ItemClickHandler::onPlayerLeftClickEntity);
    }

    @SubscribeEvent
    public static void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            new EmptyRightClickToServer(true, event.getHand() == InteractionHand.MAIN_HAND).toServer();
        }
        ItemUseEventHandler.execute(event.getEntity().m_21120_(event.getHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), event, ItemClickHandler::onPlayerRightClickEmpty);
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemUseEventHandler.execute(event.getItemStack(), event, ItemClickHandler::onPlayerRightClickBlock);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        ItemUseEventHandler.execute(event.getItemStack(), event, ItemClickHandler::onPlayerRightClickEntity);
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        ItemUseEventHandler.execute(event.getEntity().m_21205_(), event, ItemClickHandler::onCriticalHit);
    }

    public static interface ItemClickHandler {
        public boolean predicate(ItemStack var1, Class<? extends PlayerEvent> var2, PlayerEvent var3);

        default public void onPlayerLeftClickEmpty(ItemStack stack, PlayerInteractEvent.LeftClickEmpty event) {
        }

        default public void onPlayerLeftClickBlock(ItemStack stack, PlayerInteractEvent.LeftClickBlock event) {
        }

        default public void onPlayerLeftClickEntity(ItemStack stack, AttackEntityEvent event) {
        }

        default public void onCriticalHit(ItemStack stack, CriticalHitEvent event) {
        }

        default public void onPlayerRightClickEmpty(ItemStack stack, PlayerInteractEvent.RightClickEmpty event) {
        }

        default public void onPlayerRightClickBlock(ItemStack stack, PlayerInteractEvent.RightClickBlock event) {
        }

        default public void onPlayerRightClickEntity(ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        }
    }

    @FunctionalInterface
    public static interface TriCon<T> {
        public void accept(ItemClickHandler var1, ItemStack var2, T var3);
    }
}

